<?php require_once($_SERVER["DOCUMENT_ROOT"]."/admin/header.php");

$spInfo = getquery("tbl_jobcard_services","AND serviceName IN ('Stamp Value','Stamp Premium','Stamp Plus','Stamp RFT Premium','Stamp RFT Plus') AND cashier_status = 'Done' AND status = 'Active' ORDER BY id DESC","*");
?>
	<div class="content-wrapper">
		<!-- START PAGE CONTENT-->
		<div class="page-heading">
			<h1 class="page-title">Stamp Program AMC Report</h1>
			<?=alert_box($emsg,$type)?>
		</div>
		<div class="page-content fade-in-up">
			<div class="ibox">
				<div class="ibox-head">
					<div class="ibox-title">Stamp Program AMC Report</div>
				</div>
				<div class="ibox-body">
					<table class="table table-striped table-bordered table-hover table-responsive dataTable" id="example-table" cellspacing="10" width="100%">
						<thead>
							<tr>
								<th>ID</th>
								<th>Vehicle Info</th>
								<th>Jobcard No.</th>
								<th>Invoice No.</th>
								<th>Services</th>
								<th>Free Services</th>
								<th>Services Used</th>
								<th>Balance Services</th>
								<th>Expiry Date</th>
							</tr>
						</thead>
						<tbody>
						<?php
						for($i=0; $i<count($spInfo); $i++){
							$invinfo = getquery("tbl_all_bills_record","AND jid = '".$spInfo[$i]->jid."' ORDER BY id DESC","invoiceno");
							
							$mminfo = getquery("tbl_job_card","AND srnumber = '".$spInfo[$i]->jid."' ORDER BY id DESC","make,model");
							
							$unamcinfo = getquery("tbl_jobcard_services","AND vnumber = '".$spInfo[$i]->vnumber."' AND updateDate >= '".$spInfo[$i]->updateDate."' AND status = 'Active' AND serviceName = 'Nitrogen'","COUNT(id) AS tot");
							
							$alminfo = getquery("tbl_jobcard_services","AND vnumber = '".$spInfo[$i]->vnumber."' AND updateDate >= '".$spInfo[$i]->updateDate."' AND status = 'Active' AND serviceName = '3D Wheel Alignment'","COUNT(id) AS tot");
							
							$balinfo = getquery("tbl_jobcard_services","AND vnumber = '".$spInfo[$i]->vnumber."' AND updateDate >= '".$spInfo[$i]->updateDate."' AND status = 'Active' AND serviceName = 'Balancing'","COUNT(id) AS tot");
							
							$robalminfo = getquery("tbl_jobcard_services","AND vnumber = '".$spInfo[$i]->vnumber."' AND updateDate >= '".$spInfo[$i]->updateDate."' AND status = 'Active' AND serviceName = 'Robotic Wheel Alignment'","COUNT(id) AS tot");
							
							$rftbalinfo = getquery("tbl_jobcard_services","AND vnumber = '".$spInfo[$i]->vnumber."' AND updateDate >= '".$spInfo[$i]->updateDate."' AND status = 'Active' AND serviceName = 'RFT Balancing'","COUNT(id) AS tot");
							
							if($spInfo[$i]->serviceName == 'Stamp Value'){
								$freeSrv = 'Nitrogen AMC';
								$srvUsed = $unamcinfo[0]->tot;
								$balSrv = 'Unlimited';
							}
							else if($spInfo[$i]->serviceName == 'Stamp Premium'){
								$freeSrv = '3 3D Wheel Alignment <br> 3 Balancing <br> Nitrogen';
								$srvUsed = $alminfo[0]->tot .' 3D Wheel Alignment <br> '.$balinfo[0]->tot .' Balancing <br> '.$unamcinfo[0]->tot;
								$balSrv = (3 - $alminfo[0]->tot).' 3D Wheel Alignment <br> '.(3 - $balinfo[0]->tot).' Balancing <br> Unlimited';
							}
							else if($spInfo[$i]->serviceName == 'Stamp Plus'){
								$freeSrv = '3 3D Wheel Alignment <br> 3 Balancing';
								$srvUsed = $alminfo[0]->tot .' 3D Wheel Alignment <br> '.$balinfo[0]->tot .' Balancing';
								$balSrv = (3 - $alminfo[0]->tot).' 3D Wheel Alignment <br> '.(3 - $balinfo[0]->tot).' Balancing';
							}
							else if($spInfo[$i]->serviceName == 'Stamp RFT Premium'){
								$freeSrv = '3 Robotic Wheel Alignment <br> 3 RFT Balancing <br> Nitrogen';
								$srvUsed = $robalminfo[0]->tot .' Robotic Wheel Alignment <br> '.$rftbalinfo[0]->tot .' RFT Balancing <br> '.$unamcinfo[0]->tot;
								$balSrv = (3 - $robalminfo[0]->tot).' Robotic Wheel Alignment <br> '.(3 - $rftbalinfo[0]->tot).' RFT Balancing <br> Unlimited';
							}
							else if($spInfo[$i]->serviceName == 'Stamp RFT Plus'){
								$freeSrv = '3 Robotic Alignment <br> 3 RFT Balancing';
								$srvUsed = $robalminfo[0]->tot .' Robotic Wheel Alignment <br> '.$rftbalinfo[0]->tot .' RFT Balancing';
								$balSrv = (3 - $robalminfo[0]->tot).' Robotic Wheel Alignment <br> '.(3 - $rftbalinfo[0]->tot);
							}
							
							$srvDate = date('Y-m-d',$spInfo[$i]->createDate);
							$expdate = date('Y-m-d', strtotime('+1 year', strtotime($srvDate)));
							?>
							<tr>
								<td><?=$i+1?></td>
								<td><?=$spInfo[$i]->vnumber?><br><?=$mminfo[0]->make .' - '.$mminfo[0]->model?></td>
								<td><?=$spInfo[$i]->jid?></td>
								<td>S-<?=$invinfo[0]->invoiceno?></td>
								<td><?=$spInfo[$i]->serviceName?></td>
								<td><?=$freeSrv?></td>
								<td><?=$srvUsed?></td>
								<td><?=$balSrv?></td>
								<td><?=$expdate?></td>
							</tr>
						<?php } ?>
						</tbody>
						<tfoot>
							<tr>
								<th>ID</th>
								<th>Vehicle Info</th>
								<th>Jobcard No.</th>
								<th>Invoice No.</th>
								<th>Service Name</th>
								<th>Free Services</th>
								<th>Services Used</th>
								<th>Balance Services</th>
								<th>Expiry Date</th>
							</tr>
						</tfoot>
					</table>
				</div>
			</div>
		</div>
		<!-- END PAGE CONTENT-->
<?php require_once($_SERVER["DOCUMENT_ROOT"]."/admin/footer.php"); ?>